<?php

declare(strict_types=1);

use GXModules\ExampleVendor\AfterbuyManipulator\Admin\Classes\AfterbuyOrderDataPreparedListener;
use GXModules\ExampleVendor\AfterbuyManipulator\Admin\Classes\AfterbuyProductPreparedForImportListener;
use GXModules\ExampleVendor\AfterbuyManipulator\AfterbuyManipulatorServiceProvider;
use GXModules\Gambio\Afterbuy\Admin\Classes\Products\Events\ProductPreparedForImport;
use GXModules\Gambio\Afterbuy\Classes\Events\AfterbuyOrderDataPrepared;

/**
 * Class AfterbuyAdminApplicationTopExtender
 *
 * @package GXModules\Gambio\Afterbuy\Admin\Overloads\AdminApplicationTopExtenderComponent
 */
class AfterbuyManipulatorAdminApplicationTopExtender extends AfterbuyManipulatorAdminApplicationTopExtender_parent
{
    public function proceed()
    {
        parent::proceed();
        
        LegacyDependencyContainer::getInstance()->registerProvider(AfterbuyManipulatorServiceProvider::class);
        LegacyDependencyContainer::getInstance()
            ->attachEventListener(ProductPreparedForImport::class, AfterbuyProductPreparedForImportListener::class);
        LegacyDependencyContainer::getInstance()
            ->attachEventListener(AfterbuyOrderDataPrepared::class, AfterbuyOrderDataPreparedListener::class);
    }
}
