<?php

namespace GXModules\ExampleVendor\AfterbuyManipulator\Admin\Classes;

use GXModules\Gambio\Afterbuy\Classes\Events\AfterbuyOrderDataPrepared;

class AfterbuyOrderDataPreparedListener
{
    public function __invoke(AfterbuyOrderDataPrepared $afterbuyOrderDataPrepared): void
    {
        $orderData = $afterbuyOrderDataPrepared->getOrderData();
        $orderData['Kfax'] = '+49-1234-9876';
        $this->log(print_r($orderData, true));
        $afterbuyOrderDataPrepared->setOrderData($orderData);
    }
    
    private function log(string $message): void
    {
        $message = date('c') . " | {$message}\n";
        $file = DIR_FS_CATALOG . '/logfiles/abevent_orderdataprepared.log.txt';
        file_put_contents($file, $message, FILE_APPEND);
    }
}