<?php

namespace GXModules\ExampleVendor\AfterbuyManipulator\Admin\Classes;

use Gambio\Core\Configuration\Services\ConfigurationFinder;
use GXModules\Gambio\Afterbuy\Admin\Classes\Products\Events\ProductPreparedForImport;
use StringType;

class AfterbuyProductPreparedForImportListener
{
    private ConfigurationFinder $configurationFinder;
    
    
    public function __construct(ConfigurationFinder $configurationFinder)
    {
        
        $this->configurationFinder = $configurationFinder;
    }
    
    
    public function __invoke(ProductPreparedForImport $event): void
    {
        $addPrefix = (bool)$this->configurationFinder->get('modules/ExampleVendorAfterbuyManipulator/addPrefix');
        
        if ($addPrefix) {
            $this->addPrefix($event);
        } else {
            $afterbuyProduct = $event->afterbuyProduct();
            $this->log("{$afterbuyProduct->getName()} – prefixing disabled, leaving it untouched");
        }
    }
    
    
    private function addPrefix(ProductPreparedForImport $event): void
    {
        $product      = $event->gxEngineProduct();
        $languageCode = new \LanguageCode(new StringType('de'));
        $productName  = $product->getName($languageCode);
        if (strpos($productName, '[AB] ') !== 0) {
            $newName = '[AB] ' . $productName;
        } else {
            $newName = $productName;
        }
        $product->setName(new StringType($newName), $languageCode);
        $this->log("{$productName} => $newName");
    }
    
    
    /**
     * Writes a line to a log file.
     *
     * PRIMITIVE STUB FOR PROTOTYPE ONLY! DO NOT USE THIS IN PRODUCTION!!
     *
     * @param string $message
     *
     * @return void
     */
    private function log(string $message): void
    {
        $message = date('c') . " | {$message}\n";
        file_put_contents(DIR_FS_CATALOG . '/logfiles/abprodimportlistener.txt', $message, FILE_APPEND);
    }
}
