<?php

namespace GXModules\ExampleVendor\AfterbuyManipulator;

use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Configuration\Services\ConfigurationFinder;
use GXModules\ExampleVendor\AfterbuyManipulator\Admin\Classes\AfterbuyProductPreparedForImportListener;

class AfterbuyManipulatorServiceProvider extends AbstractServiceProvider
{
    
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            AfterbuyProductPreparedForImportListener::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(AfterbuyProductPreparedForImportListener::class)
            ->addArgument(ConfigurationFinder::class);
    }
    
}
