-- Adminer 4.7.1 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `gm_counter_extern_search`;
CREATE TABLE `gm_counter_extern_search` (
  `gm_counter_extern_search_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_extern_search_name` varchar(255) DEFAULT NULL,
  `gm_counter_extern_search_engine` varchar(255) DEFAULT NULL,
  `gm_counter_extern_search_hits` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gm_counter_extern_search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `gm_counter_info`;
CREATE TABLE `gm_counter_info` (
  `gm_counter_info_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_info_type_id` int(10) NOT NULL DEFAULT '0',
  `gm_counter_info_hits` int(10) NOT NULL DEFAULT '0',
  `gm_counter_info_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`gm_counter_info_id`),
  KEY `gm_counter_info_type_id` (`gm_counter_info_type_id`,`gm_counter_info_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_info` (`gm_counter_info_id`, `gm_counter_info_type_id`, `gm_counter_info_hits`, `gm_counter_info_name`) VALUES
(157,	1,	20,	'UNKNOWN'),
(158,	2,	20,	'UNKNOWN'),
(159,	5,	21,	''),
(160,	1,	9,	'Safari 537.3'),
(161,	2,	10,	'Windows NT'),
(162,	5,	6,	'fr'),
(163,	3,	6,	'1536x864'),
(164,	4,	7,	'24'),
(165,	5,	3,	'en-US'),
(166,	3,	2,	'1280x960'),
(167,	4,	2,	'UNKNOWN'),
(168,	3,	1,	'1920x1080'),
(169,	1,	1,	'Gecko based');

DROP TABLE IF EXISTS `gm_counter_info_type`;
CREATE TABLE `gm_counter_info_type` (
  `gm_counter_info_type_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_info_type_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`gm_counter_info_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_info_type` (`gm_counter_info_type_id`, `gm_counter_info_type_name`) VALUES
(1,	'browser'),
(2,	'platform'),
(3,	'resolution'),
(4,	'color_depth'),
(5,	'origin');

DROP TABLE IF EXISTS `gm_counter_intern_search`;
CREATE TABLE `gm_counter_intern_search` (
  `gm_counter_intern_search_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_intern_search_name` varchar(255) DEFAULT NULL,
  `gm_counter_intern_search_hits` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gm_counter_intern_search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `gm_counter_ip`;
CREATE TABLE `gm_counter_ip` (
  `gm_ip_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_ip_value` varchar(255) DEFAULT NULL,
  `gm_ip_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`gm_ip_id`),
  KEY `gm_ip_date` (`gm_ip_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_ip` (`gm_ip_id`, `gm_ip_value`, `gm_ip_date`) VALUES
(257,	'9c869c5b6ea65ee8fd6e26cbc98f593a',	'2020-11-26 07:48:41'),
(258,	'4574ee99ffd2624787cfe3ef4b346987',	'2020-11-26 07:49:17'),
(259,	'6795156a1fb17521883410f86ff5351b',	'2020-11-26 09:11:01'),
(260,	'f513ae1fb4d063b60a61cda872de2a7e',	'2020-11-26 15:17:02'),
(261,	'4c4f4b64b98b434e65a959d397438272',	'2020-11-26 15:17:02'),
(262,	'5b67cf582dcacb865d7dcdc08cf7a62b',	'2020-11-26 15:17:13'),
(263,	'24023b51ca2a6f814d3ae70d8dbaa077',	'2020-11-26 15:18:33');

DROP TABLE IF EXISTS `gm_counter_page`;
CREATE TABLE `gm_counter_page` (
  `gm_counter_page_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_page_name` varchar(255) DEFAULT NULL,
  `gm_counter_page_type` varchar(255) DEFAULT NULL,
  `gm_counter_page_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`gm_counter_page_id`),
  KEY `gm_counter_page_date` (`gm_counter_page_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_page` (`gm_counter_page_id`, `gm_counter_page_name`, `gm_counter_page_type`, `gm_counter_page_date`) VALUES
(18603,	'index.php',	'content',	'2020-11-25 00:01:02'),
(18604,	'index.php',	'content',	'2020-11-25 00:11:06'),
(18605,	'index.php',	'content',	'2020-11-25 00:21:01'),
(18606,	'index.php',	'content',	'2020-11-25 00:31:01'),
(18607,	'index.php',	'content',	'2020-11-25 00:41:01'),
(18608,	'index.php',	'content',	'2020-11-25 00:51:02'),
(18609,	'index.php',	'content',	'2020-11-25 01:01:01'),
(18610,	'index.php',	'content',	'2020-11-25 01:11:02'),
(18611,	'index.php',	'content',	'2020-11-25 01:21:01'),
(18612,	'index.php',	'content',	'2020-11-25 01:31:02'),
(18613,	'index.php',	'content',	'2020-11-25 01:41:01'),
(18614,	'index.php',	'content',	'2020-11-25 01:51:02'),
(18615,	'index.php',	'content',	'2020-11-25 02:01:01'),
(18616,	'index.php',	'content',	'2020-11-25 02:11:01'),
(18617,	'index.php',	'content',	'2020-11-25 02:21:02'),
(18618,	'index.php',	'content',	'2020-11-25 02:31:03'),
(18619,	'index.php',	'content',	'2020-11-25 02:41:01'),
(18620,	'index.php',	'content',	'2020-11-25 02:51:02'),
(18621,	'index.php',	'content',	'2020-11-25 03:01:01'),
(18622,	'index.php',	'content',	'2020-11-25 03:11:01'),
(18623,	'index.php',	'content',	'2020-11-25 03:21:02'),
(18624,	'index.php',	'content',	'2020-11-25 03:31:02'),
(18625,	'index.php',	'content',	'2020-11-25 03:41:01'),
(18626,	'index.php',	'content',	'2020-11-25 03:51:02'),
(18627,	'index.php',	'content',	'2020-11-25 04:01:01'),
(18628,	'index.php',	'content',	'2020-11-25 04:11:01'),
(18629,	'index.php',	'content',	'2020-11-25 04:21:01'),
(18630,	'index.php',	'content',	'2020-11-25 04:31:01'),
(18631,	'index.php',	'content',	'2020-11-25 04:41:01'),
(18632,	'index.php',	'content',	'2020-11-25 04:51:01'),
(18633,	'index.php',	'content',	'2020-11-25 05:01:02'),
(18634,	'index.php',	'content',	'2020-11-25 05:11:01'),
(18635,	'index.php',	'content',	'2020-11-25 05:21:01'),
(18636,	'index.php',	'content',	'2020-11-25 05:31:02'),
(18637,	'index.php',	'content',	'2020-11-25 05:41:01'),
(18638,	'index.php',	'content',	'2020-11-25 05:51:02'),
(18639,	'index.php',	'content',	'2020-11-25 06:01:01'),
(18640,	'index.php',	'content',	'2020-11-25 06:11:01'),
(18641,	'index.php',	'content',	'2020-11-25 06:11:19'),
(18642,	'index.php',	'content',	'2020-11-25 06:11:24'),
(18643,	'2',	'coid',	'2020-11-25 06:11:28'),
(18644,	'2',	'coid',	'2020-11-25 06:17:46'),
(18645,	'index.php',	'content',	'2020-11-25 06:21:01'),
(18646,	'2',	'coid',	'2020-11-25 06:24:06'),
(18647,	'2',	'coid',	'2020-11-25 06:30:03'),
(18648,	'2',	'coid',	'2020-11-25 06:30:52'),
(18649,	'index.php',	'content',	'2020-11-25 06:31:01'),
(18650,	'2',	'coid',	'2020-11-25 06:31:33'),
(18651,	'2',	'coid',	'2020-11-25 06:35:48'),
(18652,	'index.php',	'content',	'2020-11-25 06:36:03'),
(18653,	'index.php',	'content',	'2020-11-25 06:36:24'),
(18654,	'index.php',	'content',	'2020-11-25 06:36:30'),
(18655,	'index.php',	'content',	'2020-11-25 06:37:45'),
(18656,	'3',	'cat',	'2020-11-25 06:37:47'),
(18657,	'3',	'cat',	'2020-11-25 06:37:48'),
(18658,	'3',	'cat',	'2020-11-25 06:38:09'),
(18659,	'3',	'cat',	'2020-11-25 06:38:09'),
(18660,	'3',	'cat',	'2020-11-25 06:40:21'),
(18661,	'3',	'cat',	'2020-11-25 06:40:21'),
(18662,	'3',	'cat',	'2020-11-25 06:40:45'),
(18663,	'3',	'cat',	'2020-11-25 06:40:45'),
(18664,	'index.php',	'content',	'2020-11-25 06:41:01'),
(18665,	'3',	'cat',	'2020-11-25 06:52:23'),
(18666,	'3',	'cat',	'2020-11-25 06:52:24'),
(18667,	'3',	'cat',	'2020-11-25 06:52:36'),
(18668,	'3',	'cat',	'2020-11-25 06:52:37'),
(18669,	'3',	'cat',	'2020-11-25 06:53:24'),
(18670,	'3',	'cat',	'2020-11-25 06:54:26'),
(18671,	'3',	'cat',	'2020-11-25 06:54:54'),
(18672,	'3',	'cat',	'2020-11-25 06:55:22'),
(18673,	'3',	'cat',	'2020-11-25 06:56:47'),
(18674,	'index.php',	'content',	'2020-11-25 07:01:02'),
(18675,	'index.php',	'content',	'2020-11-25 07:11:02'),
(18676,	'index.php',	'content',	'2020-11-25 07:21:02'),
(18677,	'index.php',	'content',	'2020-11-25 07:31:01'),
(18678,	'3',	'cat',	'2020-11-25 07:34:10'),
(18679,	'3',	'cat',	'2020-11-25 07:34:11'),
(18680,	'index.php',	'content',	'2020-11-25 07:34:15'),
(18681,	'2',	'cat',	'2020-11-25 07:34:24'),
(18682,	'2',	'cat',	'2020-11-25 07:34:30'),
(18683,	'2',	'cat',	'2020-11-25 07:34:36'),
(18684,	'login.php',	'content',	'2020-11-25 07:34:40'),
(18685,	'2',	'cat',	'2020-11-25 07:35:19'),
(18686,	'2',	'cat',	'2020-11-25 07:35:40'),
(18687,	'2',	'cat',	'2020-11-25 07:35:51'),
(18688,	'2',	'cat',	'2020-11-25 07:36:26'),
(18689,	'index.php',	'content',	'2020-11-25 07:41:01'),
(18690,	'2',	'cat',	'2020-11-25 07:41:04'),
(18691,	'2',	'cat',	'2020-11-25 07:41:09'),
(18692,	'3',	'cat',	'2020-11-25 07:42:03'),
(18693,	'3',	'cat',	'2020-11-25 07:42:03'),
(18694,	'3',	'cat',	'2020-11-25 07:43:43'),
(18695,	'3',	'cat',	'2020-11-25 07:43:43'),
(18696,	'index.php',	'content',	'2020-11-25 07:51:01'),
(18697,	'3',	'cat',	'2020-11-25 07:55:04'),
(18698,	'3',	'cat',	'2020-11-25 07:55:05'),
(18699,	'index.php',	'content',	'2020-11-25 07:55:23'),
(18700,	'index.php',	'content',	'2020-11-25 07:55:31'),
(18701,	'1',	'cat',	'2020-11-25 07:56:31'),
(18702,	'1',	'cat',	'2020-11-25 07:56:32'),
(18703,	'3',	'cat',	'2020-11-25 07:56:37'),
(18704,	'3',	'cat',	'2020-11-25 07:56:37'),
(18705,	'index.php',	'content',	'2020-11-25 08:01:02'),
(18706,	'3',	'cat',	'2020-11-25 08:09:35'),
(18707,	'1',	'cat',	'2020-11-25 08:09:40'),
(18708,	'1',	'cat',	'2020-11-25 08:09:40'),
(18709,	'1',	'cat',	'2020-11-25 08:10:16'),
(18710,	'1',	'cat',	'2020-11-25 08:10:17'),
(18711,	'1',	'cat',	'2020-11-25 08:10:38'),
(18712,	'1',	'cat',	'2020-11-25 08:10:38'),
(18713,	'index.php',	'content',	'2020-11-25 08:11:02'),
(18714,	'1',	'cat',	'2020-11-25 08:11:24'),
(18715,	'1',	'cat',	'2020-11-25 08:11:24'),
(18716,	'1',	'cat',	'2020-11-25 08:12:26'),
(18717,	'1',	'cat',	'2020-11-25 08:12:27'),
(18718,	'1',	'cat',	'2020-11-25 08:15:02'),
(18719,	'1',	'cat',	'2020-11-25 08:15:02'),
(18720,	'1',	'cat',	'2020-11-25 08:15:09'),
(18721,	'1',	'cat',	'2020-11-25 08:15:09'),
(18722,	'1',	'cat',	'2020-11-25 08:15:22'),
(18723,	'1',	'cat',	'2020-11-25 08:15:23'),
(18724,	'1',	'cat',	'2020-11-25 08:15:48'),
(18725,	'1',	'cat',	'2020-11-25 08:15:49'),
(18726,	'11',	'cat',	'2020-11-25 08:16:01'),
(18727,	'index.php',	'content',	'2020-11-25 08:21:02'),
(18728,	'index.php',	'content',	'2020-11-25 08:31:01'),
(18729,	'11',	'cat',	'2020-11-25 08:36:01'),
(18730,	'index.php',	'content',	'2020-11-25 08:41:01'),
(18731,	'index.php',	'content',	'2020-11-25 08:51:01'),
(18732,	'11',	'cat',	'2020-11-25 08:51:21'),
(18733,	'1',	'cat',	'2020-11-25 08:51:34'),
(18734,	'1',	'cat',	'2020-11-25 08:51:35'),
(18735,	'12',	'cat',	'2020-11-25 08:51:38'),
(18736,	'13',	'cat',	'2020-11-25 08:51:49'),
(18737,	'13',	'cat',	'2020-11-25 08:53:59'),
(18738,	'106',	'prd',	'2020-11-25 08:54:05'),
(18739,	'index.php',	'content',	'2020-11-25 09:01:01'),
(18740,	'index.php',	'content',	'2020-11-25 09:11:01'),
(18741,	'106',	'prd',	'2020-11-25 09:13:43'),
(18742,	'106',	'prd',	'2020-11-25 09:15:17'),
(18743,	'13',	'cat',	'2020-11-25 09:15:40'),
(18744,	'1',	'cat',	'2020-11-25 09:15:54'),
(18745,	'1',	'cat',	'2020-11-25 09:15:55'),
(18746,	'13',	'cat',	'2020-11-25 09:16:07'),
(18747,	'113',	'prd',	'2020-11-25 09:16:11'),
(18748,	'13',	'cat',	'2020-11-25 09:16:15'),
(18749,	'index.php',	'content',	'2020-11-25 09:21:02'),
(18750,	'index.php',	'content',	'2020-11-25 09:31:02'),
(18751,	'index.php',	'content',	'2020-11-25 09:41:01'),
(18752,	'index.php',	'content',	'2020-11-25 09:51:02'),
(18753,	'index.php',	'content',	'2020-11-25 10:01:02'),
(18754,	'index.php',	'content',	'2020-11-25 10:11:01'),
(18755,	'index.php',	'content',	'2020-11-25 10:21:02'),
(18756,	'index.php',	'content',	'2020-11-25 10:31:02'),
(18757,	'index.php',	'content',	'2020-11-25 10:41:02'),
(18758,	'index.php',	'content',	'2020-11-25 10:51:02'),
(18759,	'index.php',	'content',	'2020-11-25 11:01:02'),
(18760,	'index.php',	'content',	'2020-11-25 11:11:01'),
(18761,	'index.php',	'content',	'2020-11-25 11:21:01'),
(18762,	'index.php',	'content',	'2020-11-25 11:31:01'),
(18763,	'index.php',	'content',	'2020-11-25 11:41:01'),
(18764,	'index.php',	'content',	'2020-11-25 11:51:01'),
(18765,	'index.php',	'content',	'2020-11-25 12:01:01'),
(18766,	'index.php',	'content',	'2020-11-25 12:11:01'),
(18767,	'index.php',	'content',	'2020-11-25 12:21:01'),
(18768,	'index.php',	'content',	'2020-11-25 12:31:01'),
(18769,	'index.php',	'content',	'2020-11-25 12:41:01'),
(18770,	'index.php',	'content',	'2020-11-25 12:51:02'),
(18771,	'index.php',	'content',	'2020-11-25 13:01:03'),
(18772,	'index.php',	'content',	'2020-11-25 13:11:01'),
(18773,	'index.php',	'content',	'2020-11-25 13:21:02'),
(18774,	'index.php',	'content',	'2020-11-25 13:31:01'),
(18775,	'index.php',	'content',	'2020-11-25 13:41:01'),
(18776,	'index.php',	'content',	'2020-11-25 13:51:02'),
(18777,	'index.php',	'content',	'2020-11-25 14:01:01'),
(18778,	'index.php',	'content',	'2020-11-25 14:11:01'),
(18779,	'index.php',	'content',	'2020-11-25 14:21:01'),
(18780,	'index.php',	'content',	'2020-11-25 14:31:01'),
(18781,	'index.php',	'content',	'2020-11-25 14:41:01'),
(18782,	'index.php',	'content',	'2020-11-25 15:01:01'),
(18783,	'index.php',	'content',	'2020-11-25 15:11:01'),
(18784,	'index.php',	'content',	'2020-11-25 15:21:02'),
(18785,	'index.php',	'content',	'2020-11-25 15:31:01'),
(18786,	'index.php',	'content',	'2020-11-25 15:41:03'),
(18787,	'index.php',	'content',	'2020-11-25 15:51:01'),
(18788,	'index.php',	'content',	'2020-11-25 16:01:02'),
(18789,	'index.php',	'content',	'2020-11-25 16:11:01'),
(18790,	'index.php',	'content',	'2020-11-25 16:21:02'),
(18791,	'index.php',	'content',	'2020-11-25 16:31:01'),
(18792,	'index.php',	'content',	'2020-11-25 16:41:01'),
(18793,	'index.php',	'content',	'2020-11-25 16:51:02'),
(18794,	'index.php',	'content',	'2020-11-25 17:01:01'),
(18795,	'index.php',	'content',	'2020-11-25 17:11:01'),
(18796,	'index.php',	'content',	'2020-11-25 17:21:02'),
(18797,	'index.php',	'content',	'2020-11-25 17:31:01'),
(18798,	'index.php',	'content',	'2020-11-25 17:41:01'),
(18799,	'index.php',	'content',	'2020-11-25 17:51:02'),
(18800,	'index.php',	'content',	'2020-11-25 18:01:02'),
(18801,	'index.php',	'content',	'2020-11-25 18:11:01'),
(18802,	'index.php',	'content',	'2020-11-25 18:21:02'),
(18803,	'index.php',	'content',	'2020-11-25 18:31:02'),
(18804,	'index.php',	'content',	'2020-11-25 18:41:01'),
(18805,	'index.php',	'content',	'2020-11-25 18:51:02'),
(18806,	'index.php',	'content',	'2020-11-25 19:01:01'),
(18807,	'index.php',	'content',	'2020-11-25 19:11:01'),
(18808,	'index.php',	'content',	'2020-11-25 19:21:01'),
(18809,	'index.php',	'content',	'2020-11-25 19:31:01'),
(18810,	'index.php',	'content',	'2020-11-25 19:41:01'),
(18811,	'index.php',	'content',	'2020-11-25 19:51:02'),
(18812,	'index.php',	'content',	'2020-11-25 20:01:02'),
(18813,	'index.php',	'content',	'2020-11-25 20:11:01'),
(18814,	'index.php',	'content',	'2020-11-25 20:21:02'),
(18815,	'index.php',	'content',	'2020-11-25 20:31:02'),
(18816,	'index.php',	'content',	'2020-11-25 20:41:01'),
(18817,	'index.php',	'content',	'2020-11-25 20:51:02'),
(18818,	'index.php',	'content',	'2020-11-25 21:01:01'),
(18819,	'index.php',	'content',	'2020-11-25 21:11:01'),
(18820,	'index.php',	'content',	'2020-11-25 21:21:01'),
(18821,	'index.php',	'content',	'2020-11-25 21:31:02'),
(18822,	'index.php',	'content',	'2020-11-25 21:41:01'),
(18823,	'index.php',	'content',	'2020-11-25 21:51:02'),
(18824,	'index.php',	'content',	'2020-11-25 22:01:01'),
(18825,	'index.php',	'content',	'2020-11-25 22:11:01'),
(18826,	'index.php',	'content',	'2020-11-25 22:21:01'),
(18827,	'index.php',	'content',	'2020-11-25 22:31:01'),
(18828,	'index.php',	'content',	'2020-11-25 22:41:01'),
(18829,	'index.php',	'content',	'2020-11-25 23:01:02'),
(18830,	'index.php',	'content',	'2020-11-25 23:11:01'),
(18831,	'index.php',	'content',	'2020-11-25 23:21:02'),
(18832,	'index.php',	'content',	'2020-11-25 23:31:01'),
(18833,	'index.php',	'content',	'2020-11-25 23:41:01'),
(18834,	'index.php',	'content',	'2020-11-25 23:51:02'),
(18835,	'index.php',	'content',	'2020-11-26 00:01:01'),
(18836,	'index.php',	'content',	'2020-11-26 00:11:04'),
(18837,	'index.php',	'content',	'2020-11-26 00:21:02'),
(18838,	'index.php',	'content',	'2020-11-26 00:31:02'),
(18839,	'index.php',	'content',	'2020-11-26 00:41:01'),
(18840,	'index.php',	'content',	'2020-11-26 00:51:02'),
(18841,	'index.php',	'content',	'2020-11-26 01:01:01'),
(18842,	'index.php',	'content',	'2020-11-26 01:11:01'),
(18843,	'index.php',	'content',	'2020-11-26 01:21:02'),
(18844,	'index.php',	'content',	'2020-11-26 01:31:01'),
(18845,	'index.php',	'content',	'2020-11-26 01:41:01'),
(18846,	'index.php',	'content',	'2020-11-26 01:51:01'),
(18847,	'index.php',	'content',	'2020-11-26 02:01:02'),
(18848,	'index.php',	'content',	'2020-11-26 02:11:01'),
(18849,	'index.php',	'content',	'2020-11-26 02:21:02'),
(18850,	'index.php',	'content',	'2020-11-26 02:31:01'),
(18851,	'index.php',	'content',	'2020-11-26 02:41:01'),
(18852,	'index.php',	'content',	'2020-11-26 02:51:02'),
(18853,	'index.php',	'content',	'2020-11-26 03:01:02'),
(18854,	'index.php',	'content',	'2020-11-26 03:11:01'),
(18855,	'index.php',	'content',	'2020-11-26 03:21:02'),
(18856,	'index.php',	'content',	'2020-11-26 03:31:01'),
(18857,	'index.php',	'content',	'2020-11-26 03:41:02'),
(18858,	'index.php',	'content',	'2020-11-26 03:51:02'),
(18859,	'index.php',	'content',	'2020-11-26 04:01:02'),
(18860,	'index.php',	'content',	'2020-11-26 04:11:01'),
(18861,	'index.php',	'content',	'2020-11-26 04:21:02'),
(18862,	'index.php',	'content',	'2020-11-26 04:31:02'),
(18863,	'index.php',	'content',	'2020-11-26 04:41:02'),
(18864,	'index.php',	'content',	'2020-11-26 04:51:01'),
(18865,	'index.php',	'content',	'2020-11-26 05:01:02'),
(18866,	'index.php',	'content',	'2020-11-26 05:11:01'),
(18867,	'index.php',	'content',	'2020-11-26 05:21:02'),
(18868,	'index.php',	'content',	'2020-11-26 05:31:01'),
(18869,	'index.php',	'content',	'2020-11-26 05:41:01'),
(18870,	'index.php',	'content',	'2020-11-26 05:51:02'),
(18871,	'index.php',	'content',	'2020-11-26 06:01:02'),
(18872,	'index.php',	'content',	'2020-11-26 06:11:01'),
(18873,	'index.php',	'content',	'2020-11-26 06:21:02'),
(18874,	'index.php',	'content',	'2020-11-26 06:31:02'),
(18875,	'index.php',	'content',	'2020-11-26 06:41:01'),
(18876,	'index.php',	'content',	'2020-11-26 07:01:01'),
(18877,	'index.php',	'content',	'2020-11-26 07:11:01'),
(18878,	'index.php',	'content',	'2020-11-26 07:21:01'),
(18879,	'index.php',	'content',	'2020-11-26 07:31:01'),
(18880,	'index.php',	'content',	'2020-11-26 07:41:01'),
(18881,	'index.php',	'content',	'2020-11-26 07:48:42'),
(18882,	'index.php',	'content',	'2020-11-26 07:49:04'),
(18883,	'index.php',	'content',	'2020-11-26 07:49:17'),
(18884,	'index.php',	'content',	'2020-11-26 07:49:17'),
(18885,	'14',	'cat',	'2020-11-26 07:50:30'),
(18886,	'shopping_cart.php',	'content',	'2020-11-26 07:50:36'),
(18887,	'checkout_shipping.php',	'content',	'2020-11-26 07:50:52'),
(18888,	'checkout_shipping_address.php',	'content',	'2020-11-26 07:50:56'),
(18889,	'index.php',	'content',	'2020-11-26 07:51:01'),
(18890,	'checkout_shipping.php',	'content',	'2020-11-26 07:51:05'),
(18891,	'checkout_payment.php',	'content',	'2020-11-26 07:51:08'),
(18892,	'checkout_confirmation.php',	'content',	'2020-11-26 07:51:13'),
(18893,	'checkout_confirmation.php',	'content',	'2020-11-26 07:53:47'),
(18894,	'checkout_success.php',	'content',	'2020-11-26 07:54:05'),
(18895,	'checkout_success.php',	'content',	'2020-11-26 07:54:21'),
(18896,	'16',	'cat',	'2020-11-26 07:54:24'),
(18897,	'29',	'cat',	'2020-11-26 07:54:28'),
(18898,	'29',	'cat',	'2020-11-26 07:54:49'),
(18899,	'29',	'cat',	'2020-11-26 07:54:54'),
(18900,	'116',	'prd',	'2020-11-26 07:55:04'),
(18901,	'11',	'cat',	'2020-11-26 07:57:46'),
(18902,	'99',	'prd',	'2020-11-26 07:57:50'),
(18903,	'99',	'prd',	'2020-11-26 07:58:43'),
(18904,	'29',	'cat',	'2020-11-26 07:59:10'),
(18905,	'29',	'cat',	'2020-11-26 08:00:22'),
(18906,	'11',	'cat',	'2020-11-26 08:00:25'),
(18907,	'99',	'prd',	'2020-11-26 08:00:28'),
(18908,	'index.php',	'content',	'2020-11-26 08:01:01'),
(18909,	'99',	'prd',	'2020-11-26 08:01:37'),
(18910,	'11',	'cat',	'2020-11-26 08:02:30'),
(18911,	'100',	'prd',	'2020-11-26 08:02:32'),
(18912,	'29',	'cat',	'2020-11-26 08:04:08'),
(18913,	'116',	'prd',	'2020-11-26 08:04:10'),
(18914,	'29',	'cat',	'2020-11-26 08:04:46'),
(18915,	'115',	'prd',	'2020-11-26 08:04:50'),
(18916,	'11',	'cat',	'2020-11-26 08:05:00'),
(18917,	'100',	'prd',	'2020-11-26 08:05:02'),
(18918,	'29',	'cat',	'2020-11-26 08:08:03'),
(18919,	'12',	'cat',	'2020-11-26 08:10:06'),
(18920,	'102',	'prd',	'2020-11-26 08:10:10'),
(18921,	'index.php',	'content',	'2020-11-26 08:11:01'),
(18922,	'102',	'prd',	'2020-11-26 08:11:05'),
(18923,	'29',	'cat',	'2020-11-26 08:11:09'),
(18924,	'114',	'prd',	'2020-11-26 08:11:13'),
(18925,	'29',	'cat',	'2020-11-26 08:12:27'),
(18926,	'115',	'prd',	'2020-11-26 08:12:30'),
(18927,	'20',	'cat',	'2020-11-26 08:19:30'),
(18928,	'20',	'cat',	'2020-11-26 08:19:34'),
(18929,	'index.php',	'content',	'2020-11-26 08:21:02'),
(18930,	'20',	'cat',	'2020-11-26 08:22:12'),
(18931,	'account.php',	'content',	'2020-11-26 08:22:15'),
(18932,	'index.php',	'content',	'2020-11-26 08:26:24'),
(18933,	'index.php',	'content',	'2020-11-26 08:31:02'),
(18934,	'index.php',	'content',	'2020-11-26 08:41:01'),
(18935,	'index.php',	'content',	'2020-11-26 08:51:01'),
(18936,	'index.php',	'content',	'2020-11-26 09:01:01'),
(18937,	'login.php',	'content',	'2020-11-26 09:07:48'),
(18938,	'index.php',	'content',	'2020-11-26 09:11:01'),
(18939,	'login.php',	'content',	'2020-11-26 09:11:06'),
(18940,	'index.php',	'content',	'2020-11-26 09:21:01'),
(18941,	'login.php',	'content',	'2020-11-26 09:23:36'),
(18942,	'index.php',	'content',	'2020-11-26 09:31:01'),
(18943,	'index.php',	'content',	'2020-11-26 09:41:01'),
(18944,	'index.php',	'content',	'2020-11-26 09:51:02'),
(18945,	'30',	'cat',	'2020-11-26 09:54:51'),
(18946,	'index.php',	'content',	'2020-11-26 10:01:01'),
(18947,	'index.php',	'content',	'2020-11-26 10:11:01'),
(18948,	'index.php',	'content',	'2020-11-26 10:21:02'),
(18949,	'index.php',	'content',	'2020-11-26 10:31:01'),
(18950,	'index.php',	'content',	'2020-11-26 10:41:01'),
(18951,	'index.php',	'content',	'2020-11-26 10:51:01'),
(18952,	'index.php',	'content',	'2020-11-26 11:01:02'),
(18953,	'index.php',	'content',	'2020-11-26 11:11:01'),
(18954,	'index.php',	'content',	'2020-11-26 11:15:54'),
(18955,	'index.php',	'content',	'2020-11-26 11:16:31'),
(18956,	'index.php',	'content',	'2020-11-26 11:17:20'),
(18957,	'index.php',	'content',	'2020-11-26 11:19:30'),
(18958,	'index.php',	'content',	'2020-11-26 11:21:02'),
(18959,	'shopping_cart.php',	'content',	'2020-11-26 11:26:37'),
(18960,	'checkout_shipping.php',	'content',	'2020-11-26 11:26:39'),
(18961,	'checkout_payment.php',	'content',	'2020-11-26 11:26:44'),
(18962,	'checkout_payment.php',	'content',	'2020-11-26 11:26:53'),
(18963,	'checkout_confirmation.php',	'content',	'2020-11-26 11:26:58'),
(18964,	'checkout_confirmation.php',	'content',	'2020-11-26 11:27:10'),
(18965,	'checkout_payment.php',	'content',	'2020-11-26 11:30:49'),
(18966,	'index.php',	'content',	'2020-11-26 11:31:02'),
(18967,	'checkout_payment.php',	'content',	'2020-11-26 11:32:50'),
(18968,	'checkout_payment.php',	'content',	'2020-11-26 11:33:40'),
(18969,	'checkout_confirmation.php',	'content',	'2020-11-26 11:33:47'),
(18970,	'checkout_confirmation.php',	'content',	'2020-11-26 11:34:07'),
(18971,	'checkout_success.php',	'content',	'2020-11-26 11:34:23'),
(18972,	'index.php',	'content',	'2020-11-26 11:41:02'),
(18973,	'index.php',	'content',	'2020-11-26 11:51:01'),
(18974,	'index.php',	'content',	'2020-11-26 12:01:01'),
(18975,	'index.php',	'content',	'2020-11-26 12:11:01'),
(18976,	'index.php',	'content',	'2020-11-26 12:21:02'),
(18977,	'index.php',	'content',	'2020-11-26 12:31:02'),
(18978,	'index.php',	'content',	'2020-11-26 12:41:01'),
(18979,	'index.php',	'content',	'2020-11-26 12:51:02'),
(18980,	'index.php',	'content',	'2020-11-26 13:01:01'),
(18981,	'index.php',	'content',	'2020-11-26 13:11:01'),
(18982,	'index.php',	'content',	'2020-11-26 13:21:02'),
(18983,	'index.php',	'content',	'2020-11-26 13:31:02'),
(18984,	'index.php',	'content',	'2020-11-26 13:41:01'),
(18985,	'index.php',	'content',	'2020-11-26 13:51:02'),
(18986,	'index.php',	'content',	'2020-11-26 14:01:02'),
(18987,	'index.php',	'content',	'2020-11-26 14:11:01'),
(18988,	'index.php',	'content',	'2020-11-26 14:21:02'),
(18989,	'index.php',	'content',	'2020-11-26 14:31:01'),
(18990,	'index.php',	'content',	'2020-11-26 14:41:01'),
(18991,	'index.php',	'content',	'2020-11-26 15:01:02'),
(18992,	'index.php',	'content',	'2020-11-26 15:11:01'),
(18993,	'index.php',	'content',	'2020-11-26 15:17:02'),
(18994,	'index.php',	'content',	'2020-11-26 15:17:02'),
(18995,	'password_double_opt.php',	'content',	'2020-11-26 15:17:12'),
(18996,	'index.php',	'content',	'2020-11-26 15:17:13'),
(18997,	'password_double_opt.php',	'content',	'2020-11-26 15:17:24'),
(18998,	'password_double_opt.php',	'content',	'2020-11-26 15:18:33'),
(18999,	'password_double_opt.php',	'content',	'2020-11-26 15:18:33'),
(19000,	'login.php',	'content',	'2020-11-26 15:18:47'),
(19001,	'account.php',	'content',	'2020-11-26 15:19:01'),
(19002,	'index.php',	'content',	'2020-11-26 15:21:04');

DROP TABLE IF EXISTS `gm_counter_page_history`;
CREATE TABLE `gm_counter_page_history` (
  `gm_counter_page_history_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_page_history_name` varchar(255) DEFAULT NULL,
  `gm_counter_page_history_type` varchar(255) DEFAULT NULL,
  `gm_counter_page_history_hits` int(10) DEFAULT NULL,
  `gm_counter_page_history_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`gm_counter_page_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_page_history` (`gm_counter_page_history_id`, `gm_counter_page_history_name`, `gm_counter_page_history_type`, `gm_counter_page_history_hits`, `gm_counter_page_history_date`) VALUES
(685,	'index.php',	'content',	621,	'2020-11-20 00:00:00'),
(686,	'account.php',	'content',	2,	'2020-11-20 00:00:00'),
(687,	'26',	'cat',	1,	'2020-11-20 00:00:00'),
(688,	'shopping_cart.php',	'content',	3,	'2020-11-20 00:00:00'),
(689,	'checkout_shipping.php',	'content',	3,	'2020-11-20 00:00:00'),
(690,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(691,	'checkout_shipping.php',	'content',	1,	'2020-11-20 00:00:00'),
(692,	'checkout_payment.php',	'content',	4,	'2020-11-20 00:00:00'),
(693,	'checkout_payment.php',	'content',	1,	'2020-11-20 00:00:00'),
(694,	'checkout_confirmation.php',	'content',	4,	'2020-11-20 00:00:00'),
(695,	'checkout_confirmation.php',	'content',	1,	'2020-11-20 00:00:00'),
(696,	'checkout_success.php',	'content',	1,	'2020-11-20 00:00:00'),
(697,	'account.php',	'content',	1,	'2020-11-20 00:00:00'),
(698,	'account.php',	'content',	1,	'2020-11-20 00:00:00'),
(699,	'account_history_info.php',	'content',	1,	'2020-11-20 00:00:00'),
(700,	'account_history_info.php',	'content',	1,	'2020-11-20 00:00:00'),
(701,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(702,	'account.php',	'content',	1,	'2020-11-20 00:00:00'),
(703,	'account_history_info.php',	'content',	1,	'2020-11-20 00:00:00'),
(704,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(705,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(706,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(707,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(708,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(709,	'logoff.php',	'content',	1,	'2020-11-20 00:00:00'),
(710,	'shop.php',	'content',	1,	'2020-11-20 00:00:00'),
(711,	'shop.php',	'content',	1,	'2020-11-20 00:00:00'),
(712,	'shop.php',	'content',	1,	'2020-11-20 00:00:00'),
(713,	'shop.php',	'content',	1,	'2020-11-20 00:00:00'),
(714,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(715,	'wish_list.php',	'content',	1,	'2020-11-20 00:00:00'),
(716,	'wish_list.php',	'content',	1,	'2020-11-20 00:00:00'),
(717,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(718,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(719,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(720,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(721,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(722,	'12',	'cat',	3,	'2020-11-20 00:00:00'),
(723,	'105',	'prd',	2,	'2020-11-20 00:00:00'),
(724,	'105',	'prd',	1,	'2020-11-20 00:00:00'),
(725,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(726,	'105',	'prd',	1,	'2020-11-20 00:00:00'),
(727,	'3',	'cat',	51,	'2020-11-20 00:00:00'),
(728,	'1',	'cat',	9,	'2020-11-20 00:00:00'),
(729,	'2',	'cat',	9,	'2020-11-20 00:00:00'),
(730,	'1',	'cat',	1,	'2020-11-20 00:00:00'),
(731,	'1',	'cat',	1,	'2020-11-20 00:00:00'),
(732,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(733,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(734,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(735,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(736,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(737,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(738,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(739,	'login.php',	'content',	18,	'2020-11-20 00:00:00'),
(740,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(741,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(742,	'3',	'cat',	1,	'2020-11-20 00:00:00'),
(743,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(744,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(745,	'11',	'cat',	4,	'2020-11-20 00:00:00'),
(746,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(747,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(748,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(749,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(750,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(751,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(752,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(753,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(754,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(755,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(756,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(757,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(758,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(759,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(760,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(761,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(762,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(763,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(764,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(765,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(766,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(767,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(768,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(769,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(770,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(771,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(772,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(773,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(774,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(775,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(776,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(777,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(778,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(779,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(780,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(781,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(782,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(783,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(784,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(785,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(786,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(787,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(788,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(789,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(790,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(791,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(792,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(793,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(794,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(795,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(796,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(797,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(798,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(799,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(800,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(801,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(802,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(803,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(804,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(805,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(806,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(807,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(808,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(809,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(810,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(811,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(812,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(813,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(814,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(815,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(816,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(817,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(818,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(819,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(820,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(821,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(822,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(823,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(824,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(825,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(826,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(827,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(828,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(829,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(830,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(831,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(832,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(833,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(834,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(835,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(836,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(837,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(838,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(839,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(840,	'index.php',	'content',	1,	'2020-11-20 00:00:00'),
(841,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(842,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(843,	'6',	'cat',	1,	'2020-11-23 00:00:00'),
(844,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(845,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(846,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(847,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(848,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(849,	'127',	'prd',	1,	'2020-11-23 00:00:00'),
(850,	'99',	'prd',	1,	'2020-11-23 00:00:00'),
(851,	'99',	'prd',	1,	'2020-11-23 00:00:00'),
(852,	'99',	'prd',	1,	'2020-11-23 00:00:00'),
(853,	'99',	'prd',	1,	'2020-11-23 00:00:00'),
(854,	'99',	'prd',	1,	'2020-11-23 00:00:00'),
(855,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(856,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(857,	'28',	'prd',	1,	'2020-11-23 00:00:00'),
(858,	'28',	'prd',	1,	'2020-11-23 00:00:00'),
(859,	'28',	'prd',	1,	'2020-11-23 00:00:00'),
(860,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(861,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(862,	'6',	'cat',	1,	'2020-11-23 00:00:00'),
(863,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(864,	'6',	'cat',	1,	'2020-11-23 00:00:00'),
(865,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(866,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(867,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(868,	'13',	'prd',	1,	'2020-11-23 00:00:00'),
(869,	'36',	'cat',	1,	'2020-11-23 00:00:00'),
(870,	'127',	'prd',	1,	'2020-11-23 00:00:00'),
(871,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(872,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(873,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(874,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(875,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(876,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(877,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(878,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(879,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(880,	'3',	'coid',	23,	'2020-11-23 00:00:00'),
(881,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(882,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(883,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(884,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(885,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(886,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(887,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(888,	'7',	'coid',	1,	'2020-11-23 00:00:00'),
(889,	'4',	'coid',	12,	'2020-11-23 00:00:00'),
(890,	'4',	'coid',	1,	'2020-11-23 00:00:00'),
(891,	'4',	'coid',	1,	'2020-11-23 00:00:00'),
(892,	'4',	'coid',	1,	'2020-11-23 00:00:00'),
(893,	'4',	'coid',	1,	'2020-11-23 00:00:00'),
(894,	'36',	'cat',	1,	'2020-11-23 00:00:00'),
(895,	'37',	'cat',	1,	'2020-11-23 00:00:00'),
(896,	'38',	'cat',	1,	'2020-11-23 00:00:00'),
(897,	'38',	'cat',	1,	'2020-11-23 00:00:00'),
(898,	'password_double_opt.php',	'content',	1,	'2020-11-23 00:00:00'),
(899,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(900,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(901,	'10',	'cat',	1,	'2020-11-23 00:00:00'),
(902,	'10',	'cat',	1,	'2020-11-23 00:00:00'),
(903,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(904,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(905,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(906,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(907,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(908,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(909,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(910,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(911,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(912,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(913,	'5',	'cat',	1,	'2020-11-23 00:00:00'),
(914,	'6',	'cat',	1,	'2020-11-23 00:00:00'),
(915,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(916,	'7',	'cat',	1,	'2020-11-23 00:00:00'),
(917,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(918,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(919,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(920,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(921,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(922,	'24',	'cat',	1,	'2020-11-23 00:00:00'),
(923,	'9',	'cat',	1,	'2020-11-23 00:00:00'),
(924,	'24',	'cat',	1,	'2020-11-23 00:00:00'),
(925,	'24',	'cat',	1,	'2020-11-23 00:00:00'),
(926,	'73',	'prd',	1,	'2020-11-23 00:00:00'),
(927,	'24',	'cat',	1,	'2020-11-23 00:00:00'),
(928,	'24',	'cat',	1,	'2020-11-23 00:00:00'),
(929,	'24',	'prd',	1,	'2020-11-23 00:00:00'),
(930,	'25',	'cat',	1,	'2020-11-23 00:00:00'),
(931,	'21',	'cat',	1,	'2020-11-23 00:00:00'),
(932,	'20',	'cat',	1,	'2020-11-23 00:00:00'),
(933,	'22',	'cat',	1,	'2020-11-23 00:00:00'),
(934,	'22',	'cat',	1,	'2020-11-23 00:00:00'),
(935,	'23',	'cat',	1,	'2020-11-23 00:00:00'),
(936,	'23',	'cat',	1,	'2020-11-23 00:00:00'),
(937,	'23',	'cat',	1,	'2020-11-23 00:00:00'),
(938,	'14',	'cat',	1,	'2020-11-23 00:00:00'),
(939,	'13',	'cat',	1,	'2020-11-23 00:00:00'),
(940,	'14',	'cat',	1,	'2020-11-23 00:00:00'),
(941,	'15',	'cat',	1,	'2020-11-23 00:00:00'),
(942,	'16',	'cat',	1,	'2020-11-23 00:00:00'),
(943,	'16',	'cat',	1,	'2020-11-23 00:00:00'),
(944,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(945,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(946,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(947,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(948,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(949,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(950,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(951,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(952,	'3889891',	'coid',	1,	'2020-11-24 00:00:00'),
(953,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(954,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(955,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(956,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(957,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(958,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(959,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(960,	'14',	'coid',	1,	'2020-11-24 00:00:00'),
(961,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(962,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(963,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(964,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(965,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(966,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(967,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(968,	'2',	'coid',	1,	'2020-11-24 00:00:00'),
(969,	'2',	'coid',	1,	'2020-11-24 00:00:00');

DROP TABLE IF EXISTS `gm_counter_visits`;
CREATE TABLE `gm_counter_visits` (
  `gm_counter_id` int(10) NOT NULL AUTO_INCREMENT,
  `gm_counter_visits_total` int(10) NOT NULL DEFAULT '0',
  `gm_counter_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`gm_counter_id`),
  KEY `gm_counter_date` (`gm_counter_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `gm_counter_visits` (`gm_counter_id`, `gm_counter_visits_total`, `gm_counter_date`) VALUES
(1,	1,	'2008-08-25 00:00:00'),
(58,	2,	'2020-11-20 09:11:01'),
(59,	3,	'2020-11-21 00:11:02'),
(60,	3,	'2020-11-22 00:11:02'),
(61,	5,	'2020-11-23 00:11:03'),
(62,	5,	'2020-11-24 00:11:02'),
(63,	4,	'2020-11-25 00:11:01'),
(64,	8,	'2020-11-26 00:11:01');

-- 2020-11-26 14:26:26
