<?php

/* --------------------------------------------------------------
  SpecialsBoxContentView.inc.php 2014-07-17 gambio
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2014 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------


  based on:
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2002-2003 osCommerce(specials.php,v 1.30 2003/02/10); www.oscommerce.com
  (c) 2003	 nextcommerce (specials.php,v 1.10 2003/08/17); www.nextcommerce.org
  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: specials.php 1292 2005-10-07 16:10:55Z mz $)

  Released under the GNU General Public License
  ---------------------------------------------------------------------------------------
 * 
 * #########################################################################################################
 * Project: developers
 * #########################################################################################################
 * 
 * SliderBoxContentView.inc.php
 * 
 * 01.06.2016 www.indiv-style.de
 * 
 * Copyright by H&S eCom 
 * @author little Pit(S.B.)
 * 
 * #########################################################################################################
 */

class SliderBoxContentView extends ContentView {

    public function __construct() {
        parent::__construct();
        $this->Slider_Box_Content();
    }

    public function Slider_Box_Content() {
        // on index.php? (home or category)
        if (strpos(strtolower(gm_get_env_info("PHP_SELF")), FILENAME_DEFAULT) !== false && isset($_GET['manufacturers_id']) == false) {
            if (empty($_GET['cPath']) == true && isset($_GET['filter_fv_id']) == false && isset($_GET['filter_price_min']) == false && isset($_GET['filter_price_max']) == false) {
                # use default slider for home

                $t_slider_set_id = (int) gm_get_conf('GM_SLIDER_INDEX_ID');
            } else {
                # look for slider_id for category
                $coo_cat_slider_handler = MainFactory::create_object('CategorySliderHandler');
                $t_slider_set_id = $coo_cat_slider_handler->get_category_slider_id($_GET['cPath']);
            }
        }
        
        // slider for productinfo
        if (strpos(strtolower(gm_get_env_info("PHP_SELF")), FILENAME_PRODUCT_INFO) !== false && isset($_GET['manufacturers_id']) == false) {
            if ($_GET['products_id'] != 0) {
                # look for slider_id for product
                $coo_product_slider_handler = MainFactory::create_object('ProductSliderHandler');
                $t_slider_set_id = $coo_product_slider_handler->get_product_slider_id($_GET['products_id']);
            }
        }

        // slider for content
        if (strpos(strtolower(gm_get_env_info("PHP_SELF")), FILENAME_CONTENT) !== false && isset($_GET['manufacturers_id']) == false) {
            if (!empty($_GET['coID'])) {
                # look for slider_id for content
                $coo_content_slider_handler = MainFactory::create_object('ContentSliderHandler');
                $t_slider_set_id = $coo_content_slider_handler->get_content_slider_id($_GET['coID']);
            }
        }

        // slider for blog
        if (strpos(strtolower(gm_get_env_info("PHP_SELF")), 'blog.php') !== false && isset($_GET['blog_cat']) == true && isset($_GET['manufacturers_id']) == false) {
            if (!empty($_GET['blog_cat']) && empty($_GET['blog_item'])) {
                # look for slider_id for content
                $coo_blogcat_slider_handler = MainFactory::create_object('BlogcatSliderHandler');
                $t_slider_set_id = $coo_blogcat_slider_handler->get_blog_cat_slider_id($_GET['blog_cat']);
            } elseif (!empty($_GET['blog_cat']) && !empty($_GET['blog_item'])) {
                # look for slider_id for content
                $coo_blogitem_slider_handler = MainFactory::create_object('BlogitemSliderHandler');
                $t_slider_set_id = $coo_blogitem_slider_handler->get_blog_item_slider_id($_GET['blog_item']);
            }
        }
        $this->box_content = $t_slider_set_id;
    }

}
